#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      set similar to Jones and Marshall (1996)
c=======================================================================

#define two_dim

      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: fac=1.0
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=120*fac;km=25*fac;jmt=imt
#ifdef two_dim
      jmt=3
#endif
      dx=250/fac; 
      dz=100/fac; 
      dt_in=15/fac
      eps2D_sor = 1e-5
      eps3D_sor = 1e-4
      runlen=12./24. /fac**3
      snap_int = 15*60./86400. 
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
      enable_hydrostatic         =.false.
      enable_quicker_advection   =.true.
      enable_biharmonic_friction =.true.
      enable_vert_biha_friction  =.true.
      enable_biharmonic_diffusion=.true.
      enable_vert_biha_diffusion =.true.
      Ahbi = (5./fac**2)*dx**2
      Khbi = Ahbi
      Avbi = (0.2/fac**2)*dz**2
      Kvbi = Avbi
      lat_ref=30.
      beta   =0.0
      N_0 = 2.5e-3
      M_0 = 0.0
      end subroutine set_parameter


      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: B0,x,fxa,y  ! temp = b/0.2*tho_0/g
c ----------------------------------
c      add here initial conditions
c ----------------------------------
      do k=1,km  ! Rossby radius is  N h /(f pi)
       do j=1,jmt
        do i=1,imt
         x=float(i)/float(imt)
#ifdef two_dim
         B0=1e-9*sin(x*2.5*pi)
#else
         B0=1e-9*sin(x*2.5*pi)*cos(y*3.7*pi)
#endif
         b(i,j,k,:)  = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones




      subroutine boundary_conditions
      use cpflame_module
      implicit none
      integer :: i,j
      real :: x,y
      real :: f0  = 50 *0.2/rho_0*g /4185.5 ,fxa
c       b=0.2Temp/rho_0*g    ! temp = b/0.2*tho_0/g
c      surf_flux  = 50 *0.2/rho_0*g /4185.5 
      surf_flux=0
      do j=1,jmt
       do i=1,imt
         x=float(i-imt/2)*dx
         y=float(j-jmt/2)*dx
         fxa = sqrt( x**2+y**2 )
         if (fxa<5e3) surf_flux(i,j)=f0
       enddo
      enddo
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
