#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      Vertical shear instability
c=======================================================================

#define two_dim

      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: fac=1.0
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=4*64*fac;km=60*fac;jmt=imt
#ifdef two_dim
      jmt=3
#endif
      dx=0.25/fac 
      dz=0.25/fac 
      dt_in=0.025/fac
      eps2D_sor = 1e-6
      eps3D_sor = 1e-6
      runlen=360./86400.0 / fac**2
      snap_int = 1/86400.0
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
c      enable_4th_advection       =.true.
      enable_hydrostatic         =.false.
c      enable_biharmonic_friction =.true.
c      enable_vert_biha_friction  =.true.
c      enable_biharmonic_diffusion=.true.
c      enable_vert_biha_diffusion =.true.
c      Ahbi = (5e-3/fac**2)*dx**2
c      Khbi = Ahbi
c      Avbi = (5e-3/fac**2)*dx**2
c      Kvbi = Avbi
      A_h = 20e-3/fac**2
      K_h = A_h
      A_v = A_h
      K_v = A_h


      lat_ref=0.
      beta   =0.
      N_0 = 0.0
      M_0 = 0.0
      end subroutine set_parameter




      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: fxa
      do k=1,km
       do j=1,jmt
        do i=1,imt
#ifdef two_dim
         fxa=5e-2*zt(1)*sin(xt(i)/(20*dx)*pi)
#else
         fxa=9e-3*zt(1)*sin(xt(i)/(20*dx)*pi)*cos(yt(j)/(16*dx)*pi)
#endif
         b(i,j,k,:)=1e-2*tanh( (fxa+zt(k)-zt(km/2) ) /zt(1)*100 )
         b(i,j,k,:)=b(i,j,k,:)*maskT(i,j,k)
         u(i,j,k,1,:)= 2+tanh( (zt(k)-zt(km/2))/zt(1)*100)
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: T_rest,B0
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      js=max(2,js_pe); je = min(je_pe,jmt-1)
      T_rest=1./(30.*dt)
      do k=1,km
       do i=2,15
        do j=js,je
         b0=1e-2*tanh( (zt(k)-zt(km/2) ) /zt(1)*100 )
         b(i,j,k,taup1)=b(i,j,k,taup1)+maskT(i,j,k)*c2dt* 
     &                 t_rest*(B0-b(i,j,k,taum1))
        enddo
       enddo
      enddo
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: T_rest,B0
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------

      js=max(2,js_pe); je = min(je_pe,jmt-1)
      T_rest=1./(30.*dt)
      do k=1,km
       do i=2,15
        do j=js,je
         B0=2+tanh( (zt(k)-zt(km/2))/zt(1)*100)
         fu(i,j,k)= fu(i,j,k)+maskU(i,j,k)*
     &            T_rest*(B0-u(i,j,k,1,taum1))
        enddo
       enddo
      enddo
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
c      surf_tau(:,:,1) =-0.1*dt/dz
c      bott_tau(:,:,1) =-0.1*dt/dz
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
