#include "options.inc"


c#define with_topography

c=======================================================================
c     Templates for setup
c
c      idealised MOC with freshwater forcing
c      see also ../extra_setup/salinity_THC.F
c=======================================================================

c increase this parameter to enhance resolution
#define RESOLVE 0.25
#define vRESOLVE 0.5


      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: f_0
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=64 *RESOLVE
      km=30 *vRESOLVE
      jmt   = imt

      dx=80e3  /RESOLVE
      dt_in=2400.0  /RESOLVE  
      dz=50.0  /vRESOLVE
      runlen = 365*50000
      snap_int =  365! 360

      A_h=5.0e4 /RESOLVE**2 ! u_t = A u_xx,  1/T = A /L^2 
      A_v=1e-4
      K_v=1e-4
c      K_gm=0000.0
      K_h=0000.0 
      cdbot = 0e-5!*RESOLVE
      cdint = 2e-6
      eps2D_sor = 1e-9

c      enable_noslip               = .true.
      enable_interior_stress      = .true.
c      enable_bottom_stress        = .true.
      enable_hydrostatic          = .true.
      enable_quicker_advection    = .true.  

      gamma=0.01
      lat_ref = 0
      beta = 2*omega/radius
      N_0     = 0.004
      M_0     = 0
#ifndef enable_diag_tracer
      print*,'ERROR'
      print*,' enable_diag_tracer in options.inc '
      call halt_stop('error')
#endif
      end subroutine set_parameter

      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: bstar,B0,x,y
c ----------------------------------
c      add here initial conditions
c ----------------------------------
      end subroutine initial_conditions

      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones

      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
      end subroutine momentum_restoring_zones

      subroutine boundary_conditions
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      call salinity_boundary_conditions

      end subroutine boundary_conditions

      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography

