c
c----------------------------------------------------------------
c     Timing module for SPFLAME
c
c     A timer is turned on by a call to the subroutine "tic" and turned
c     off by a call to the subroutine "toc".
c
c          call tic ('name')
c          ...code to be timed....
c          call toc ('name')
c
c     Note that the code fragment could be inside a loop.
c     The function timing_secs gives the cpu time spend 
c     between the two calls. 
c
c     Notes: the user may has to supply a function
c     which measure the cpu time on a certain (unknown) machine.
c
c
c                                 Mar 2002, C.Eden
c----------------------------------------------------------------
c
       module timing_module
       implicit none

       integer, parameter, private :: max_counter = 1000
       integer,private             :: act_counter = 0

       character (len=80),private  :: ref_counter(max_counter)
       real,private                :: counter(0:max_counter)
       real,private                :: now(0:max_counter)

       private elapsed
       public tic,toc

       contains

       function elapsed()
c
c      elapsed should give the elasped cpu (user) time
c
       real :: elapsed
c      a function which gives elapsed cpu time is needed here
#if defined IRIX_host || defined T3E_host || defined C90_host 
       real (kind=4) :: second
       elapsed = second()
#elif defined LINUX_host || defined LINUX_real8_host
c       real (kind=4) :: secnds
c       real (kind=4), save :: h_time= 0.0
c       elapsed = secnds(h_time)
c       real (kind=8) :: dclock
c       elapsed =dclock()
       real (kind=4) :: etime,tarray(2)
       elapsed=etime(tarray)
#elif defined SX5_host 
       real tarray(2),etime,sec
       sec=etime(tarray)
       elapsed=tarray(1)
#elif defined SR8000_host 
       integer :: i
       call clock(i,2)
       elapsed = i
#elif defined ALPHA_host 
       real (kind=4) :: etime,tarray(2)
       elapsed=etime(tarray)
#elif defined SUN_host 
       real (kind=4) :: etime,tarray(2)
       elapsed=etime(tarray)
#elif defined AIX_host 
       REAL (kind=4) :: etime_
       TYPE TB_TYPE
         SEQUENCE
         REAL (kind=4) :: USRTIME
         REAL (kind=4) :: SYSTIME
       END TYPE
       TYPE (TB_TYPE) ETIME_STRUCT
       elapsed = etime_(ETIME_STRUCT)
       elapsed = etime_struct%usrtime
#else
      elapsed =0.0
#endif
       end function elapsed


       subroutine tic(ref)
       character (len=*), intent(in)  :: ref
       integer :: n,len
       now(0)=elapsed()
       len=len_trim(ref)
       do n=1,act_counter
        if (ref(1:len) == ref_counter(n)(1:len) ) then
         now(n) = now(0)
         counter(0) = counter(0)+elapsed()-now(0)
         return
        endif
       enddo
       if (act_counter == max_counter ) then
        print*,' ERROR:'
        print*,' number of counters exceeds max_counter = ',max_counter
        print*,' in tic'
        print*,' ref = ',ref
c        call sub_flush(6)
c        call halt_stop(' in timing (1) ')
       endif
       act_counter = act_counter + 1
       ref_counter(act_counter) = ref
       now(act_counter) = elapsed()
       counter(0) = counter(0)+elapsed()-now(0)
       end subroutine tic

       subroutine toc(ref)
       character (len=*), intent(in) :: ref
       integer :: n,len

       now(0)=elapsed()
       len=len_trim(ref)
       do n=1,act_counter
        if (ref(1:len) == ref_counter(n)(1:len) ) then
         counter(n) = counter(n)+now(0)-now(n)
         counter(0) = counter(0)+elapsed()-now(0)
         return
        endif
       enddo
       print*,' ERROR:'
       print*,' cannot find ',ref(1:len),' in my list'
       print*,' in toc'
c       call sub_flush(6)
c       call halt_stop(' in timing (2) ')
       end subroutine toc

       function timing_secs(ref)
       character (len=*), intent(in) :: ref
       real :: timing_secs
       integer :: n,len
       if (ref=='tictoc') then
         timing_secs = counter(0)
         return
       endif
       len=len_trim(ref)
       do n=1,act_counter
        if (ref(1:len) == ref_counter(n)(1:len) ) then
         timing_secs = counter(n)
         return
        endif
       enddo
       print*,' ERROR:'
       print*,' cannot find ',ref(1:len),' in my list'
       print*,' in timing_secs'
c       call sub_flush(6)
c       call halt_stop(' in timing (3) ')
       end function timing_secs

       end module timing_module
