#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      This is identical to the 1. exp. in Wardle and Marshall 2000, JPO
c=======================================================================


      subroutine set_parameter
      use cpflame_module
      implicit none
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=128;km=92;jmt=26
      dx=20.0e3
      dz=50.0
      dt_in=600.0
      K_h=000.0
      K_v=0.0e-4
      A_h=0000.0
      A_v=1.e-4
      eps2D_sor = 1e-12
      runlen=365.0
      snap_int = 5.0
      enable_noslip              = .true.
      enable_cyclic_x            = .true.
      enable_quicker_advection   = .true.
      enable_bottom_stress       = .true.
      enable_biharmonic_friction = .true.
      Ahbi = 1e11
      cdbot=8e-5
      lat_ref = 45.0
      beta    = 2*omega*cos(lat_ref/180.*pi)/radius
      N_0     = 0.0022
      M_0     = 0.0
      end subroutine set_parameter


      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: z,r,x,y,B0
c ----------------------------------
c      add here initial conditions
c ----------------------------------

      do k=1,km
       do j=1,jmt
        do i=1,imt
         x=float(i)/float(imt)
         y=float(j)/float(jmt)
         B0=1e-6*sin(x*2.5*pi)*cos(y*4*pi)
         b(i,j,k,:) = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions


      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
      integer :: k,i,j
      real :: x,y
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      do j=1,jmt
       do i=1,imt
        y = (yu(j)-yu(2))/ (yu(jmt-1)-yu(2))
        surf_tau(i,j,1) = .2e-3*sin(pi*y)*maskU(i,j,km-1)
       enddo
      enddo
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
