#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      swashing two layer initial value problem
c=======================================================================

      subroutine set_parameter
      use cpflame_module
      implicit none
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=64*1;km=20*1;jmt=3
      dx=0.25 /1
      dz=0.25 /1
      dt_in=0.5/4
      eps2D_sor = 1e-6
      eps3D_sor = 1e-6
      runlen = 360/86400.
      snap_int = 2./86400.
      enable_4th_advection       =.true.
c      enable_quicker_advection       =.true.
      enable_hydrostatic         =.false.
      enable_biharmonic_friction =.true.
      enable_vert_biha_friction  =.true.
      enable_biharmonic_diffusion=.true.
      enable_vert_biha_diffusion =.true.
      Ahbi = 2e-3*dx**2
      Avbi = Ahbi
      Khbi = Ahbi
      Kvbi = Ahbi
      lat_ref=0.
      beta   =0.
      N_0 = 0.
      M_0 = 0.
      end subroutine set_parameter

        

      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      do k=1,km
       do j=1,jmt
        do i=1,imt
         b(i,j,k,:)=
     &         -0.01*tanh( (zt(k)-zt(km/2)
     &      -zt(1)*cos(i*2./imt) ) /zt(1)*-20 )
         b(i,j,k,:)=b(i,j,k,:)*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones



      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones




      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
