

c=======================================================================
c
c     Setup for an idealized tracer for setup theiss1.F
c     linked in the code in ../extra_modules/tracer.F
c=======================================================================

#define RESOLVE  2.0

      subroutine tracer_set_number
c ----------------------------------
c     set number of tracers
c ----------------------------------
      use tracer_module
      implicit none
      nt=1
      end subroutine tracer_set_number


      subroutine tracer_initial_conditions
c ----------------------------------
c     initial conditions for tracer
c ----------------------------------
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k
      real :: B0,x,y
      do k=1,km
       do j=1,jmt
        do i=1,imt
         x=float(i)/float(imt)
         y = (yt(j)-yt(2))/ (yt(jmt-1)-yt(2))
         B0=-M_0**2*yt(j)
         tr(i,j,k,:,1)  = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine tracer_initial_conditions


      subroutine tracer_sources
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k,js,je, spg_width = 3*RESOLVE
      real :: T_rest=1./(5.*86400),B0
c ----------------------------------
c ----------------------------------
c      add here restoring zones, surface boundary conditions etc.
c ----------------------------------
      js=max(2,js_pe); je = min(je_pe,jmt-1)
      if (my_blk_j==1) then
       do k=1,km
        do j=2,spg_width+1
         B0=-yt(j)*M_0**2-N_0**2*zt(k)
         tr(:,j,k,taup1,1)=tr(:,j,k,taup1,1)+maskT(:,j,k)*c2dt* 
     &             t_rest/(j-1.)*(B0-tr(:,j,k,taum1,1))
        enddo
       enddo
      endif
      if (my_blk_j==n_pes_j) then
       do k=1,km
        do j=jmt-1,jmt-spg_width,-1
         B0=-yt(j)*M_0**2-N_0**2*zt(k)
         tr(:,j,k,taup1,1)=tr(:,j,k,taup1,1)+maskT(:,j,k)*c2dt* 
     &             t_rest/(-1.*(j-jmt))*(B0-tr(:,j,k,taum1,1))
        enddo
       enddo
      endif
      end subroutine tracer_sources

