#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      Rayleigh-Bernard convection
c=======================================================================

#define two_dim

      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: fac=1.0
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=64*fac;km=20*fac;jmt=imt
#ifdef two_dim
      jmt=3
#endif
      dx=0.5/fac; 
      dz=0.5/fac; 
      dt_in=0.25/fac
      eps2D_sor = 1e-6
      eps3D_sor = 1e-6
      snap_int = 5/86400.0
      runlen=300*snap_int
      enable_4th_advection       =.true.
      enable_hydrostatic         =.false.
c      enable_biharmonic_friction =.true.
c      enable_vert_biha_friction  =.true.
c      enable_biharmonic_diffusion=.true.
c      enable_vert_biha_diffusion =.true.
c      Ahbi = (10e-3/fac**2)*dx**2
c      Khbi = Ahbi
c      Avbi = (10e-3/fac**2)*dx**2
c      Kvbi = Avbi
      lat_ref=0.
      beta   =0.
      N_0 = 0.0
      M_0 = 0.0
      end subroutine set_parameter


      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: fxa
      do k=1,km
       do j=1,jmt
        do i=1,imt
#ifdef two_dim
         fxa=4e-5*sin(xt(i)/(20*dx)*pi)
#else
         fxa=4e-5*sin(xt(i)/(20*dx)*pi)*cos(yt(j)/(17*dx)*pi)
#endif
         b(i,j,k,:)=fxa
         b(i,j,k,:)=b(i,j,k,:)*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones



      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones





      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c      add here boundary conditions
c ----------------------------------
      surf_flux  = 175 *0.2/rho_0*g /4185.5 
      bottom_flux= 175 *0.2/rho_0*g /4185.5 
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
