#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      double diffusion
c=======================================================================

#define two_dim

      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: fac=1.0
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=64*fac;km=60*fac;jmt=imt
#ifdef two_dim
      jmt=3
#endif
      dx=0.0025/fac 
      dz=0.0025/fac 
      dt_in=0.00025/fac
      eps2D_sor = 1e-12
      eps3D_sor = 1e-12
      runlen=360./86400.0 
      snap_int = .1/86400.0
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
c      enable_4th_advection       =.true.
      enable_hydrostatic         =.false.
c      enable_biharmonic_friction =.true.
c      enable_vert_biha_friction  =.true.
c      enable_biharmonic_diffusion=.true.
c      enable_vert_biha_diffusion =.true.
c      Ahbi = (5e-3/fac**2)*dx**2
c      Khbi = Ahbi
c      Avbi = (5e-3/fac**2)*dx**2
c      Kvbi = Avbi
      A_h = 1e-6/fac**2
      K_h = A_h
      A_v = A_h
      K_v = A_h


      lat_ref=0.
      beta   =0.
      N_0 = 0.0
      M_0 = 0.0
      end subroutine set_parameter




      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: fxa
      do k=1,km
       do j=1,jmt
        do i=1,imt
         fxa=1e-3*zt(1)*sin(5*xt(i)/xt(imt)*2*pi)
         b(i,j,k,:)=1e-2*tanh( (fxa+zt(k)-zt(km/2) ) /zt(1)*100 )
         b(i,j,k,:)=b(i,j,k,:)*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------

      call double_diffusion
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
