#include "options.inc"


 
      subroutine momentum_tendency
c=======================================================================
c       tendencies for momentum stored in F_u, F_v and F_w
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: adv_fe(imt,jmt,km), adv_ft(imt,jmt,km)
      real :: adv_fn(imt,jmt,km), diff_fn(imt,jmt,km)
      real :: diff_fe(imt,jmt,km),diff_ft(imt,jmt,km)
      real :: fxa,fxb,fxc

#ifdef enable_smagorinsky_friction
      call smagorinsky
#endif

      js=max(2,js_pe); je = min(je_pe,jmt-1)
c---------------------------------------------------------------------------------
c      Zonal momentum equation: advective and diffusive fluxes
c---------------------------------------------------------------------------------
      adv_fe(:,js_pe:je_pe,:)=0.0; 
      adv_fn(:,js_pe:je_pe,:)=0.0; 
      adv_ft(:,js_pe:je_pe,:)=0.0; 
      if (enable_4th_mom_advection) then
       call setcyclic3D_j2(u(:,:,:,1,tau) )
       call adv_flux_u_4th(adv_fe,adv_fn,adv_ft)
      elseif (enable_quicker_mom_advection) then
       call setcyclic3D_j2(u(:,:,:,1,taum1) )
       call adv_flux_u_quicker(adv_fe,adv_fn,adv_ft)
      else
       call adv_flux_u_2nd(adv_fe,adv_fn,adv_ft)
      endif

      diff_fe(:,js_pe:je_pe,:)=0.0; 
      diff_fn(:,js_pe:je_pe,:)=0.0; 
#ifdef enable_smagorinsky_friction
      call smagorinsky_fric_u(diff_fe,diff_fn)
#else
      call harm_hfric_u(diff_fe,diff_fn)
#endif
c---------------------------------------------------------------------------------
c      vertical friction
c---------------------------------------------------------------------------------
      diff_ft(:,js_pe:je_pe,:)=0.0; 
      do k=1,km-1
       do j=js,je
        do i=2,imt-1
          diff_ft(i,j,k)=A_v*(u(i,j,k+1,1,taum1)-u(i,j,k,1,taum1))/dz
     &                   *maskU(i,j,k+1)*maskU(i,j,k)
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c      add surface and bottom boundary conditions 
c---------------------------------------------------------------------------------
      do j=js,je
       diff_ft(:,j,km-1)= surf_tau(:,j,1)*maskU(:,j,km-1)
       diff_ft(:,j,1   )= bott_tau(:,j,1)*maskU(:,j,2   )
      enddo
c---------------------------------------------------------------------------------
c    account for no slip at bottom
c---------------------------------------------------------------------------------
      if (enable_bottom_noslip) then
       do k=1,km-1
        do j=js,je
         diff_ft(:,j,k)=diff_ft(:,j,k)+2*A_v*u(:,j,k+1,1,taum1)/dz
     &                   *(1-maskU(:,j,k))*maskU(:,j,k+1)
        enddo
       enddo
      endif
c---------------------------------------------------------------------------------
c      F_u = - u u_x - v u_y - w u_z + A_h u_xx + A_v u_zz  + f_vert v - f_hor w
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         fu(i,j,k)= maskU(i,j,k)*(
     &    -(adv_fe(i,j,k) - adv_fe(i-1,j,k) )/dx
     &    -(adv_fn(i,j,k) - adv_fn(i,j-1,k) )/dx
     &    -(adv_ft(i,j,k) - adv_ft(i,j,k-1) )/dz
     &    +(diff_ft(i,j,k) - diff_ft(i,j,k-1))/dz 
     &    +(diff_fe(i,j,k) - diff_fe(i-1,j,k))/dx
     &    +(diff_fn(i,j,k) - diff_fn(i,j-1,k))/dx
     &                             )
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c      Meridional momentum equation: advective and diffusive fluxes
c---------------------------------------------------------------------------------
      adv_fe(:,js_pe:je_pe,:)=0.0; 
      adv_fn(:,js_pe:je_pe,:)=0.0; 
      adv_ft(:,js_pe:je_pe,:)=0.0; 
      if (enable_4th_mom_advection) then
       call setcyclic3D_j2(u(:,:,:,2,tau) )
       call adv_flux_v_4th(adv_fe,adv_fn,adv_ft)
      elseif (enable_quicker_mom_advection) then
       call setcyclic3D_j2(u(:,:,:,2,taum1) )
       call adv_flux_v_quicker(adv_fe,adv_fn,adv_ft)
      else
       call adv_flux_v_2nd(adv_fe,adv_fn,adv_ft)
      endif

      diff_fe(:,js_pe:je_pe,:)=0.0; 
      diff_fn(:,js_pe:je_pe,:)=0.0; 
#ifdef enable_smagorinsky_friction
      call smagorinsky_fric_v(diff_fe,diff_fn)
#else
      call harm_hfric_v(diff_fe,diff_fn)
#endif
c---------------------------------------------------------------------------------
c      vertical friction
c---------------------------------------------------------------------------------
      diff_ft(:,js_pe:je_pe,:)=0.0; 
      do k=1,km-1
       do j=js,je
        do i=2,imt-1
          diff_ft(i,j,k)=A_v*(u(i,j,k+1,2,taum1)-u(i,j,k,2,taum1))/dz
     &                   *maskV(i,j,k+1)*maskV(i,j,k)
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c      add surface and bottom boundary conditions 
c---------------------------------------------------------------------------------
      do j=js,je
       diff_ft(:,j,km-1)= surf_tau(:,j,2)*maskV(:,j,km-1)
       diff_ft(:,j,1   )= bott_tau(:,j,2)*maskV(:,j,2)
      enddo
c---------------------------------------------------------------------------------
c    account for no slip at bottom
c---------------------------------------------------------------------------------
      if (enable_bottom_noslip) then
       do k=1,km-1
        do j=js,je
         diff_ft(:,j,k)=diff_ft(:,j,k)+2*A_v*u(:,j,k+1,2,taum1)/dz
     &                   *(1-maskV(:,j,k))*maskV(:,j,k+1)
        enddo
       enddo
      endif
c---------------------------------------------------------------------------------
c      F_v = - u v_x - v v_y - w v_z + A_h v_xx + A_v v_zz - f_vert u
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         fv(i,j,k)= maskV(i,j,k)*(
     &    -(adv_fe(i,j,k) - adv_fe(i-1,j,k) )/dx
     &    -(adv_fn(i,j,k) - adv_fn(i,j-1,k) )/dx
     &    -(adv_ft(i,j,k) - adv_ft(i,j,k-1) )/dz
     &    +(diff_ft(i,j,k) - diff_ft(i,j,k-1))/dz
     &    +(diff_fe(i,j,k) - diff_fe(i-1,j,k))/dx
     &    +(diff_fn(i,j,k) - diff_fn(i,j-1,k))/dx
     &                             )
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c        vertical momentum equation: advective and diffusive fluxes
c---------------------------------------------------------------------------------
      if (.not. enable_hydrostatic) then
       adv_fe(:,js_pe:je_pe,:)=0.0; 
       adv_fn(:,js_pe:je_pe,:)=0.0; 
       adv_ft(:,js_pe:je_pe,:)=0.0; 
       if (enable_4th_mom_advection) then
        call setcyclic3D_j2(u(:,:,:,3,tau) )
        call adv_flux_w_4th(adv_fe,adv_fn,adv_ft)
       elseif (enable_quicker_mom_advection) then
        call setcyclic3D_j2(u(:,:,:,3,taum1) )
        call adv_flux_w_quicker(adv_fe,adv_fn,adv_ft)
       else
        call adv_flux_w_2nd(adv_fe,adv_fn,adv_ft)
       endif
       diff_fe(:,js_pe:je_pe,:)=0.0; 
       diff_fn(:,js_pe:je_pe,:)=0.0; 
       call harm_hfric_w(diff_fe,diff_fn)
c---------------------------------------------------------------------------------
c       vertical friction
c---------------------------------------------------------------------------------
       diff_ft(:,js_pe:je_pe,:)=0.0; 
       do k=1,km-1
        do j=js,je
         do i=2,imt-1
          diff_ft(i,j,k)=
     &    A_v*(u(i,j,k+1,3,taum1)-u(i,j,k,3,taum1))/dz
     &         *maskW(i,j,k+1)*maskW(i,j,k)
         enddo
        enddo
       enddo
c---------------------------------------------------------------------------------
c        F_w = - u w_x - v w_y - w w_z  + A_h w_xx + A_v w_zz  +f_hor u 
c---------------------------------------------------------------------------------
       do k=2,km-1
        do j=js,je
         do i=2,imt-1
          fw(i,j,k)= maskW(i,j,k)*(
     &     -(adv_fe(i,j,k) - adv_fe(i-1,j,k) )/dx
     &     -(adv_fn(i,j,k) - adv_fn(i,j-1,k) )/dx
     &     -(adv_ft(i,j,k) - adv_ft(i,j,k-1) )/dz
     &     +(diff_fe(i,j,k) - diff_fe(i-1,j,k))/dx
     &     +(diff_fn(i,j,k) - diff_fn(i,j-1,k))/dx
     &     +(diff_ft(i,j,k) - diff_ft(i,j,k-1))/dz
     &                             )
         enddo
        enddo
       enddo
      endif
c---------------------------------------------------------------------------------
c      Add coriolis force to F_u, F_v and F_w
c---------------------------------------------------------------------------------
      call coriolis_force
c---------------------------------------------------------------------------------
c       add bottom drag : u_t = - c_D u 
c---------------------------------------------------------------------------------
      if (enable_bottom_stress) then
       do j=js,je
        do i=2,imt-1
         k=max(1,kmu(i,j))
         fxa = cdbot*u(i,j,k,1,taum1)
         fu(i,j,k) = fu(i,j,k)-maskU(i,j,k)*fxa
         k=max(1,kmv(i,j))
         fxa = cdbot*u(i,j,k,2,taum1)
         fv(i,j,k) = fv(i,j,k)-maskV(i,j,k)*fxa
        enddo
       enddo
      endif
c---------------------------------------------------------------------------------
c       add interior drag : u_t = - c_D u 
c---------------------------------------------------------------------------------
      if (enable_interior_stress) then
       do k=2,km-1
        do j=js,je
         do i=2,imt-1
          fxa = cdint*u(i,j,k,1,taum1)
          fu(i,j,k) = fu(i,j,k)-maskU(i,j,k)*fxa
          fxa = cdint*u(i,j,k,2,taum1)
          fv(i,j,k) = fv(i,j,k)-maskV(i,j,k)*fxa
         enddo
        enddo
       enddo
      endif
c---------------------------------------------------------------------------------
c      add biharmonic friction
c---------------------------------------------------------------------------------
      if (enable_biharmonic_friction) then
       call biha_hfric_u(diff_fe,diff_fn)
       call biha_hfric_v(diff_fe,diff_fn)
       if (.not.enable_hydrostatic) call biha_hfric_w(diff_fe,diff_fn)
      endif
      if (enable_vert_biha_friction) then
       call biha_vfric (diff_ft,maskU,fu,1)
       call biha_vfric (diff_ft,maskV,fv,2)
       if (.not.enable_hydrostatic) then
        call biha_vfric(diff_ft,maskW,fw,3)
       endif
      endif
c---------------------------------------------------------------------------------
c       Nudging terms
c---------------------------------------------------------------------------------
      call momentum_restoring_zones
c---------------------------------------------------------------------------------
c       boundary exchange for result
c---------------------------------------------------------------------------------
      call border_exchg3D(fu,1)
      call setcyclic3D(fu)
      call border_exchg3D(fv,1)
      call setcyclic3D(fv)
      if (.not. enable_hydrostatic) then
       call border_exchg3D(fw,1)
       call setcyclic3D(fw)
      endif
      end subroutine momentum_tendency





      subroutine coriolis_force
c=======================================================================
c      Add coriolis force to F_u, F_v and F_w
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      js=max(2,js_pe); je = min(je_pe,jmt-1)

c---------------------------------------------------------------------------------
c      F_u =  A_h u_xx + A_v u_zz  + f_vert v - f_hor w +...
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         fu(i,j,k)=fu(i,j,k)+maskU(i,j,k)*
     &     coriolis_t(j)*(u(i,j  ,k,2,tau)+u(i+1,j  ,k,2,tau)+
     &                    u(i,j-1,k,2,tau)+u(i+1,j-1,k,2,tau))/4.0
        enddo
       enddo
      enddo
      if (.not. enable_hydrostatic) then
       do k=2,km-1
        do j=js,je
         do i=2,imt-1
          fu(i,j,k)=fu(i,j,k)-maskU(i,j,k)*coriolis_hor(j)*
     &           (u(i,j,k  ,3,tau) + u(i+1,j,k  ,3,tau)+
     &            u(i,j,k-1,3,tau) + u(i+1,j,k-1,3,tau) )/4.0
         enddo
        enddo
       enddo
      endif
c---------------------------------------------------------------------------------
c      F_v =  A_h v_xx + A_v v_zz - f_vert u
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         fv(i,j,k)= fv(i,j,k)-maskV(i,j,k)*
     &     (coriolis_t(j  )*(u(i-1,j  ,k,1,tau)+u(i,j  ,k,1,tau)) 
     &     +coriolis_t(j+1)*(u(i-1,j+1,k,1,tau)+u(i,j+1,k,1,tau)))/4.0
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c        F_w = - u w_x - v w_y - w w_z  + A_h w_xx + A_v w_zz + f_hor u 
c---------------------------------------------------------------------------------
      if (.not. enable_hydrostatic) then
       do k=2,km-1
        do j=js,je
         do i=2,imt-1
          fw(i,j,k)=fw(i,j,k)+maskW(i,j,k)*
     &      coriolis_hor(j)*(u(i,j,k  ,1,tau)+u(i-1,j,k  ,1,tau)+
     &                       u(i,j,k+1,1,tau)+u(i-1,j,k+1,1,tau))/4.0
         enddo
        enddo
       enddo
      endif
      end subroutine coriolis_force



      subroutine harm_hfric_u(diff_fe,diff_fn)
c=======================================================================
c       horizontal harmonic friction for u  
c       diff. fluxes are stored in diff_fe and diff_fn
c       account for no slip boundary condition if requested
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: diff_fn(imt,jmt,km), diff_fe(imt,jmt,km)

      js=max(2,js_pe); je = min(je_pe,jmt-1)
      do k=2,km-1
       do j=js,je
        do i=1,imt-1
          diff_fe(i,j,k)=A_h*(u(i+1,j,k,1,taum1)-u(i,j,k,1,taum1))/dx
        enddo
       enddo
      enddo
      call setcyclic3D(diff_fe)
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
          diff_fn(i,j,k)=A_h*(u(i,j+1,k,1,taum1)-u(i,j,k,1,taum1))/dx
     &                   *maskU(i,j+1,k)*maskU(i,j,k)
        enddo
       enddo
      enddo
      if (enable_noslip) then
       do j=js-1,je
         diff_fn(:,j,:)=diff_fn(:,j,:)-2*A_h*u(:,j,:,1,taum1)/dx
     &                   *(1-maskU(:,j+1,:))*maskU(:,j,:)
         diff_fn(:,j,:)=diff_fn(:,j,:)+2*A_h*u(:,j+1,:,1,taum1)/dx
     &                   *(1-maskU(:,j,:))*maskU(:,j+1,:)
       enddo
      endif
      call border_exchg3D(diff_fn,1)
      call setcyclic3D(diff_fn)
      end subroutine harm_hfric_u





      subroutine harm_hfric_v(diff_fe,diff_fn)
c=======================================================================
c       horizontal harmonic friction for v  
c       diff. fluxes are stored in diff_fe and diff_fn
c       account for no slip boundary condition if requested
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: diff_fn(imt,jmt,km), diff_fe(imt,jmt,km)
      js=max(2,js_pe); je = min(je_pe,jmt-1)
      do k=2,km-1
       do j=js,je
        do i=1,imt-1
          diff_fe(i,j,k)=A_h*(u(i+1,j,k,2,taum1)-u(i,j,k,2,taum1))/dx
     &                   *maskV(i+1,j,k)*maskV(i,j,k)
        enddo
       enddo
      enddo
      if (enable_noslip) then
       do j=js,je
       do i=1,imt-1
         diff_fe(i,j,:)=diff_fe(i,j,:)-2*A_h*u(i,j,:,2,taum1)/dx
     &                   *(1-maskV(i+1,j,:))*maskV(i,j,:)
         diff_fe(i,j,:)=diff_fe(i,j,:)+2*A_h*u(i+1,j,:,2,taum1)/dx
     &                   *(1-maskV(i,j,:))*maskV(i+1,j,:)
       enddo
       enddo
      endif
      call setcyclic3D(diff_fe)
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
          diff_fn(i,j,k)=A_h*(u(i,j+1,k,2,taum1)-u(i,j,k,2,taum1) )/dx
        enddo
       enddo
      enddo
      call border_exchg3D(diff_fn,1)
      call setcyclic3D(diff_fn)
      end subroutine harm_hfric_v




      subroutine harm_hfric_w(diff_fe,diff_fn)
c=======================================================================
c       horizontal harmonic friction for w  
c       diff. fluxes are stored in diff_fe and diff_fn
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: diff_fn(imt,jmt,km), diff_fe(imt,jmt,km)
      js=max(2,js_pe); je = min(je_pe,jmt-1)
      do k=2,km-1
       do j=js,je
        do i=1,imt-1
          diff_fe(i,j,k)=
     &    A_h*(u(i+1,j,k,3,taum1)-u(i,j,k,3,taum1))/dx
     &         *maskW(i+1,j,k)*maskW(i,j,k)
        enddo
       enddo
      enddo
      call setcyclic3D(diff_fe)
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
          diff_fn(i,j,k)=
     &     A_h*(u(i,j+1,k,3,taum1)-u(i,j,k,3,taum1))/dx
     &         *maskW(i,j+1,k)*maskW(i,j,k)
        enddo
       enddo
      enddo
      call border_exchg3D(diff_fn,1)
      call setcyclic3D(diff_fn)
      end subroutine harm_hfric_w
