

c=======================================================================
c
c     Setup for a simple passive tracer
c     linked in the code in ../extra_modules/tracer.F
c=======================================================================


      subroutine tracer_set_number
c ----------------------------------
c     set number of tracers
c ----------------------------------
      use tracer_module
      implicit none
      nt=1
      end subroutine tracer_set_number

      subroutine tracer_initial_conditions
c ----------------------------------
c     initial conditions for tracer
c ----------------------------------
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k
      real :: fac,B0,x,y,z
      fac = 2*0.2/rho_0*g
      do k=1,km
       do j=1,jmt
        do i=1,imt
         y = (yt(j)-yt(2))/ (yt(jmt-1)-yt(2))
         B0=fac*0.5*(tanh(-(y-0.5)/0.1)+1.0)
         tr(i,j,k,:,1)  = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo

      do j=1,jmt
       do k=km-3,km
        do i=1,imt
         y = (yt(j)-yt(2))/ (yt(jmt-1)-yt(2))
         B0=fac*0.5*(tanh(-(y-0.5)/0.1)+1.0)
         tr(i,j,k,:,1)  = (B0-0.0010**2*zt(k))*maskT(i,j,k)
        enddo
        enddo
      enddo

      end subroutine tracer_initial_conditions


      subroutine tracer_sources
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k,js,je,n
      real :: fxa,fxb
c ----------------------------------
c      add here restoring zones, surface boundary conditions etc.
c ----------------------------------

      js=max(2,js_pe); je = min(je_pe,jmt-1)
c ----------------------------------
c    diagnostic output
c ----------------------------------
      fxa=0.0
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
          fxa=fxa+tr(i,j,k,tau,1)*dx**2*dz*maskT(i,j,k)
        enddo
       enddo
      enddo
      call global_sum(fxa)
      if (my_pe==0) print*, 'total tracer content ',fxa,' mol'
      call sub_flush(6)

      end subroutine tracer_sources

