

c=======================================================================
c
c     Setup for salinity as tracer
c     linked in the code in ../extra_modules/tracer.F
c=======================================================================

c  sets diffusivity for salinity relative to diffusivity of heat

#define FAC_K_S  0.1


      subroutine tracer_set_number
c ----------------------------------
c     set number of tracers
c ----------------------------------
      use tracer_module
      implicit none
      nt=1
      end subroutine tracer_set_number



      subroutine tracer_initial_conditions
c ----------------------------------
c     initial conditions for tracer
c ----------------------------------
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k
      real :: fxa
      do k=1,km
       do j=1,jmt
        do i=1,imt
         tr(i,j,k,:,1)=-2.0*tanh( (zt(k)-zt(km/2) ) /zt(1)*100 )
         tr(i,j,k,:,1)=tr(i,j,k,:,1)*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine tracer_initial_conditions


      subroutine tracer_sources
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k,js,je
      real :: diff_fn(imt,jmt,km)
      real :: diff_fe(imt,jmt,km),diff_ft(imt,jmt,km),fxa
      real :: K_s
c ----------------------------------
c      add here restoring zones, surface boundary conditions etc.
c ----------------------------------
      K_s=FAC_K_S*K_h

      js=max(2,js_pe); je = min(je_pe,jmt-1)
c---------------------------------------------------------------------------------
c      horizontal diffusion
c---------------------------------------------------------------------------------
       diff_fe(:,js_pe:je_pe,:)=0
       diff_fn(:,js_pe:je_pe,:)=0
       diff_ft(:,js_pe:je_pe,:)=0
       do k=2,km-1
        do j=js,je
         do i=1,imt-1
          fxa=-(K_h-K_s)*maskU(i,j,k)
          diff_fe(i,j,k)=fxa*(tr(i+1,j,k,taum1,1)-tr(i,j,k,taum1,1))/dx
         enddo
        enddo
       enddo
       call setcyclic3D(diff_fe)
       do k=2,km-1
        do j=js,je 
         do i=2,imt-1
          fxa=-(K_h-K_s)*maskV(i,j,k)
          diff_fn(i,j,k)=fxa*(tr(i,j+1,k,taum1,1)-tr(i,j,k,taum1,1))/dx
         enddo
        enddo
       enddo
       call border_exchg3D(diff_fn,1); call setcyclic3D(diff_fn)
c---------------------------------------------------------------------------------
c      vertical diffusion
c---------------------------------------------------------------------------------
       do k=1,km-1
        do j=js,je
         do i=2,imt-1
          fxa=-(K_h-K_s)*maskW(i,j,k)
          diff_ft(i,j,k)=fxa*(tr(i,j,k+1,taum1,1)-tr(i,j,k,taum1,1))/dz
         enddo
        enddo
       enddo
c---------------------------------------------------------------------------------
c       time tendency of tracer: 
c       S_t + u grad S = K_h nabla^2 S - (K_h-K_S) nabla^2 S , K_S=0.2 K_h
c---------------------------------------------------------------------------------
       do k=2,km-1
        do j=js,je
         do i=2,imt-1
          tr(i,j,k,taup1,1)=tr(i,j,k,taup1,1)+maskT(i,j,k)*c2dt*( 
     &  +(diff_ft(i,j,k)-diff_ft(i,j,k-1))/dz
     &  +(diff_fe(i,j,k)-diff_fe(i-1,j,k))/dx
     &  +(diff_fn(i,j,k)-diff_fn(i,j-1,k))/dx  )
         enddo
        enddo
       enddo

      end subroutine tracer_sources



      subroutine double_diffusion
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k,js,je
      real :: diff_fn(imt,jmt,km)
      real :: diff_fe(imt,jmt,km),diff_ft(imt,jmt,km),fxa
      real :: K_s
c ----------------------------------
      K_s=FAC_K_S*K_h
c ----------------------------------
      js=max(2,js_pe); je = min(je_pe,jmt-1)
c---------------------------------------------------------------------------------
c      horizontal diffusion
c---------------------------------------------------------------------------------
       diff_fe(:,js_pe:je_pe,:)=0
       diff_fn(:,js_pe:je_pe,:)=0
       diff_ft(:,js_pe:je_pe,:)=0
       do k=2,km-1
        do j=js,je
         do i=1,imt-1
          fxa=-(K_h-K_s)*maskU(i,j,k)
          diff_fe(i,j,k)=fxa*(tr(i+1,j,k,taum1,1)-tr(i,j,k,taum1,1))/dx
         enddo
        enddo
       enddo
       call setcyclic3D(diff_fe)
       do k=2,km-1
        do j=js,je 
         do i=2,imt-1
          fxa=-(K_h-K_s)*maskV(i,j,k)
          diff_fn(i,j,k)=fxa*(tr(i,j+1,k,taum1,1)-tr(i,j,k,taum1,1))/dx
         enddo
        enddo
       enddo
       call border_exchg3D(diff_fn,1); call setcyclic3D(diff_fn)
c---------------------------------------------------------------------------------
c      vertical diffusion
c---------------------------------------------------------------------------------
       do k=1,km-1
        do j=js,je
         do i=2,imt-1
          fxa=-(K_v-K_s)*maskW(i,j,k)
          diff_ft(i,j,k)=fxa*(tr(i,j,k+1,taum1,1)-tr(i,j,k,taum1,1))/dz
         enddo
        enddo
       enddo
c---------------------------------------------------------------------------------
c       time tendency of buoyancy
c       b_t + u grad b = K_h nabla^2 b - (K_h-K_S) nabla^2 db/dS S , K_S=0.2 K_h
c       sig = 0.8 S - 0.2 T,  b=sig/rho_0*g, db/dS = 0.8 /rho_0 *g
c---------------------------------------------------------------------------------
       do k=2,km-1
        do j=js,je
         do i=2,imt-1 
          fxa=maskT(i,j,k)*c2dt * 0.8/rho_0*g
          b(i,j,k,taup1)=b(i,j,k,taup1)+fxa*( 
     &  +(diff_ft(i,j,k)-diff_ft(i,j,k-1))/dz
     &  +(diff_fe(i,j,k)-diff_fe(i-1,j,k))/dx
     &  +(diff_fn(i,j,k)-diff_fn(i,j-1,k))/dx  )
         enddo
        enddo
       enddo
      end subroutine double_diffusion





