

c=======================================================================
c
c     Setup for an idealized age tracer
c     linked in the code in ../extra_modules/tracer.F
c=======================================================================


      subroutine tracer_set_number
c ----------------------------------
c     set number of tracers
c ----------------------------------
      use tracer_module
      implicit none
      nt=1
      end subroutine tracer_set_number


      subroutine tracer_initial_conditions
c ----------------------------------
c     initial conditions for tracer
c ----------------------------------
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k
      do k=1,km
       do j=1,jmt
        do i=1,imt
         tr(i,j,k,:,1)=0*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine tracer_initial_conditions


      subroutine tracer_sources
      use cpflame_module
      use tracer_module
      implicit none
      integer :: i,j,k,js,je
c ----------------------------------
c      add here restoring zones, surface boundary conditions etc.
c ----------------------------------
      js=max(2,js_pe); je = min(je_pe,jmt-1)
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         tr(i,j,k,taup1,1)=tr(i,j,k,taup1,1)+maskT(i,j,k)*c2dt*( 
     &           1.0/86400.
     &        )
        enddo
       enddo
      enddo
      k=km-1
      do j=js,je
       do i=2,imt-1
         tr(i,j,k,taup1,1)=tr(i,j,k,taup1,1)+maskT(i,j,k)*c2dt*( 
     &                  1./(1*86400.)*(-tr(i,j,k,taum1,1)) 
     &        )
       enddo
      enddo
      end subroutine tracer_sources

