#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      This is identical to the 2. exp. in Wardle and Marshall 2000, JPO
c=======================================================================


      subroutine set_parameter
      use cpflame_module
      implicit none
c ----------------------------------
c       set here main parameter
c ----------------------------------
c      integer, parameter :: imt=128,km=92,jmt=26
      dx=10.0e3
      dz=50.0
      dt_in=300.0
      K_h=000.0
      K_v=0.0e-4
      A_h=000.0
      A_v=1.e-4
      eps2D_sor = 1e-12
      runlen=365.0
      snap_int = 5.0
      enable_noslip              = .true.
      enable_cyclic_x            = .true.
      enable_quicker_advection   = .true.
      enable_bottom_stress       = .true.
      enable_biharmonic_friction = .true.
      Ahbi = 2e10
      cdbot=8e-5
      gamma=0.01
      lat_ref = 45.0
      beta    = 2*omega*cos(lat_ref/180.*pi)/radius
      N_0     = 0.0022
      M_0     = 0.0
      end subroutine set_parameter


      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: z,fac,x,y,B0
c ----------------------------------
c      add here initial conditions
c ----------------------------------
c        d rho / dt = 0.2 kg/m^3 /K,  d rho = 0.2 dT,  d b = 0.2 dT /1000*9.81
      fac = 2*0.2/rho_0*g
      do k=1,km
       do j=1,jmt
        do i=1,imt
         x=float(i)/float(imt)
         y = (yt(j)-yt(2))/ (yt(jmt-1)-yt(2))
         B0=fac*0.5*(tanh((y-0.5)/0.3)+1.0)
         B0=B0+1e-6*sin(x*2.5*pi)*cos(y*4*pi)
         b(i,j,k,:)   = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions

      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones

      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      end subroutine boundary_conditions

      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
