#include "options.inc"

c=======================================================================
c     Templates for setup
c=======================================================================


      subroutine set_parameter
      use cpflame_module
      implicit none
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=10;km=10;jmt=10
      dx=1.0*degtom
      dz=500.0
      dt_in=3600.0
      K_h=100.0
      K_v=1.e-4
      A_h=100.0
      A_v=1.e-4
      eps2D_sor = 1e-8
      runlen=1*365.0
      snap_int = 5.0
      enable_noslip=.true.
      enable_cyclic_x=.false.
      enable_cyclic_y=.false.
      lat_ref = 45.0      
      beta    = 2*omega*cos(lat_ref/180.*pi)/radius
      N_0     = 0.005
      M_0     = 0.0
      end subroutine set_parameter




      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: z,r,x,y,B0
c ----------------------------------
c      add here initial conditions
c ----------------------------------
      do k=1,km
       do j=1,jmt
        do i=1,imt
         x=(float(i)/float(imt)-0.5)*2.
         y=(float(j)/float(jmt)-0.5)*2.
         B0 = 0.2
c     &   +1e-5*exp(-(x-0.5)**2*10.)*exp(-(y)**2*10.)
c     &               *exp(-(zt(km)-zt(k))/200. )
         b(i,j,k,:) = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions




      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones


      subroutine boundary_conditions
      use cpflame_module
      implicit none
      integer :: k,i,j
      real :: x,y
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
      integer :: i,k
      real :: z
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
