#include "options.inc"

 
      subroutine integrate
c=======================================================================
c       solve prognostic equations for u,v and w
c       boundary exchange and apply roberts time filter
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,n,js,je
      real :: fxa
      real :: bv0(imt,jmt),bu0(imt,jmt)

      js=max(2,js_pe); je = min(je_pe,jmt-1)
c---------------------------------------------------------------------------------
c      du/dt = F_u - p_x 
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         u(i,j,k,1,taup1) = u(i,j,k,1,taum1) + maskU(i,j,k)*c2dt*( 
     &     fu(i,j,k)-(p_full(i+1,j,k,tau)-p_full(i,j,k,tau))/dx)
        enddo
       enddo
      enddo
      if (enable_expl_free_surf) then
c---------------------------------------------------------------------------------
c      correct barotropic mode
c---------------------------------------------------------------------------------
        bu0(:,js_pe:je_pe)=0.
        do k=1,km-1
         do j=js,je
          do i=2,imt-1
           bu0(i,j)=bu0(i,j)+u(i,j,k,1,taup1)*maskU(i,j,k)*dz
          enddo
         enddo
        enddo
        do k=1,km-1
         do j=js,je
          do i=2,imt-1
           u(i,j,k,1,taup1)=u(i,j,k,1,taup1)
     &      +(bu(i,j,taup1)-bu0(i,j))/(1e-18+hu(i,j))*maskU(i,j,k)
          enddo
         enddo
        enddo
      endif
      call border_exchg3D(u(:,:,:,1,taup1),2)
      call setcyclic3D(u(:,:,:,1,taup1) )
c---------------------------------------------------------------------------------
c      dv/dt = F_v - p_y  
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         u(i,j,k,2,taup1) = u(i,j,k,2,taum1) + maskV(i,j,k)*c2dt*( 
     &     fv(i,j,k)-(p_full(i,j+1,k,tau)-p_full(i,j,k,tau))/dx)
        enddo
       enddo
      enddo
      if (enable_expl_free_surf) then
c---------------------------------------------------------------------------------
c      correct barotropic mode
c---------------------------------------------------------------------------------
        bv0(:,js_pe:je_pe)=0.
        do k=1,km-1
         do j=js,je
          do i=2,imt-1
           bv0(i,j)=bv0(i,j)+u(i,j,k,2,taup1)*maskV(i,j,k)*dz
          enddo
         enddo
        enddo
        do k=1,km-1
         do j=js,je
          do i=2,imt-1
           u(i,j,k,2,taup1)=u(i,j,k,2,taup1)
     &      +(bv(i,j,taup1)-bv0(i,j))/(1e-18+hv(i,j))*maskV(i,j,k)
          enddo
         enddo
        enddo
      endif
      call border_exchg3D(u(:,:,:,2,taup1),2)
      call setcyclic3D(u(:,:,:,2,taup1) )

      if (.not. enable_hydrostatic) then
c---------------------------------------------------------------------------------
c       dw/dt = F_w - psi_z 
c---------------------------------------------------------------------------------
       do k=2,km-1
        do j=js,je
         do i=2,imt-1
          u(i,j,k,3,taup1) = u(i,j,k,3,taum1)+maskW(i,j,k)*c2dt*( 
     &       fw(i,j,k)-(psi(i,j,k+1)-psi(i,j,k))/dz)
         enddo
        enddo
       enddo
       call border_exchg3D(u(:,:,:,3,taup1),2)
       call setcyclic3D(u(:,:,:,3,taup1) )
      endif
c---------------------------------------------------------------------------------
c      apply roberts time filter on time levels 
c---------------------------------------------------------------------------------
      do j=js,je
       u(:,j,:,1,tau) = u(:,j,:,1,tau) + gamma*
     &      (0.5*(u(:,j,:,1,taup1) + u(:,j,:,1,taum1)) - u(:,j,:,1,tau)) 
       u(:,j,:,2,tau) = u(:,j,:,2,tau) + gamma*
     &      (0.5*(u(:,j,:,2,taup1) + u(:,j,:,2,taum1)) - u(:,j,:,2,tau)) 
       if (.not. enable_hydrostatic) then
        u(:,j,:,3,tau) = u(:,j,:,3,tau) + gamma*
     &      (0.5*(u(:,j,:,3,taup1) + u(:,j,:,3,taum1)) - u(:,j,:,3,tau)) 
       endif
       b(:,j,:,tau) = b(:,j,:,tau) + gamma*
     &      (0.5*(b(:,j,:,taup1) + b(:,j,:,taum1)) - b(:,j,:,tau)) 
      enddo
      call border_exchg3D(u(:,:,:,1,tau),2)
      call setcyclic3D(u(:,:,:,1,tau) )
      call border_exchg3D(u(:,:,:,2,tau),2)
      call setcyclic3D(u(:,:,:,2,tau) )
      if (.not.enable_hydrostatic) then
       call border_exchg3D(u(:,:,:,3,tau),2)
       call setcyclic3D(u(:,:,:,3,tau) )
      endif
      call border_exchg3D(b(:,:,:,tau),2)
      call setcyclic3D(b(:,:,:,tau) )
      end subroutine integrate


 
      subroutine vertical_velocity
c=======================================================================
c       vertical velocity from continuity : 
c       \int_0^z w_z dz =w(z)-w(0) = - \int dz (u_x +v_y)  
c        w(z)=-int dz u_x + v_y
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je

      js=max(2,js_pe); je = min(je_pe,jmt-1)
      u(:,js_pe:je_pe,1,3,tau) = 0.0
      do k=2,km
       do j=js,je
        do i=2,imt-1
          u(i,j,k,3,tau) = u(i,j,k-1,3,tau)-maskW(i,j,k)*dz*( 
     &            (u(i,j,k,1,tau)-u(i-1,j,k,1,tau))/dx
     &           +(u(i,j,k,2,tau)-u(i,j-1,k,2,tau))/dx)
        enddo
       enddo
      enddo
      do j=js,je
       u(:,j,:,3,tau) = u(:,j,:,3,tau)*maskW(:,j,:)
      enddo
      call border_exchg3D(u(:,:,:,3,tau),2)
      call setcyclic3D(u(:,:,:,3,tau) )
      end subroutine vertical_velocity




