#include "options.inc"

c=======================================================================
c     Templates for setup
c
c      free convection
c=======================================================================

#define two_dim

      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: fac=2.0
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=32*fac;km=25*fac;jmt=imt
#ifdef two_dim
      jmt=3
#endif
      dx=1.0/fac; 
      dz=1.0/fac; 
      dt_in=1.0/fac
      eps2D_sor = 1e-6
      eps3D_sor = 1e-6
      snap_int = 20/86400.0
      runlen = 300.*snap_int
      enable_hydrostatic         =.false.
      enable_4th_advection       =.true.
      enable_biharmonic_friction =.true.
      enable_vert_biha_friction  =.true.
      enable_biharmonic_diffusion=.true.
      enable_vert_biha_diffusion =.true.
      Ahbi = (2e-3/fac**2)*dx**2
      Khbi = Ahbi
      Avbi = (2e-3/fac**2)*dx**2
      Kvbi = Avbi
      lat_ref=0.
      beta   =0.
      N_0 = 2.5e-2
      M_0 = 0.0
      end subroutine set_parameter



      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: fxa
      real :: B0,x,y
c ----------------------------------
c      add here initial conditions
c ----------------------------------
      do k=1,km
       do j=1,jmt
        do i=1,imt
         x=float(i)/float(imt)
         y=float(j)/float(jmt)
#ifdef two_dim
         B0=1e-6*sin(x*2.5*pi)
#else
         B0=1e-6*sin(x*2.5*pi)*cos(y*3.7*pi)
#endif
         b(i,j,k,:)  = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones



      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
c       b=0.2Temp/rho_0*g  
      surf_flux  = 10 *0.2/rho_0*g /4185.5 
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
