#include "options.inc"

c=======================================================================
c     Templates for setup
c
c
c      twodimensional channel forced by wind stress
c      
c=======================================================================


      subroutine set_parameter
      use cpflame_module
      implicit none
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=3;km=46;jmt=14
      dz=100.0
      dx=40.0e3
      dt_in=1200.0
      ahbi = 2e11

      K_h=000.0
      K_v=0.0e-4
      A_h=0000.0
      A_v=1.e-4
      eps2D_sor = 1e-6
      runlen=3*365.0
      snap_int = 5.0
      enable_noslip              = .true.
      enable_cyclic_x            = .true.
      enable_quicker_advection   = .true.
      enable_bottom_stress       = .true.
      enable_biharmonic_friction = .true.
      enable_hydrostatic         = .true.
      cdbot=2e-5
      lat_ref = 45.0      
      beta    = 2*omega*cos(lat_ref/180.*pi)/radius
      N_0 = 0.005
      M_0 = 0
      end subroutine set_parameter


      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: z,r,x,y,B0
c ----------------------------------
c      add here initial conditions
c ----------------------------------
      do k=1,km
       do j=1,jmt
        do i=1,imt
         y=float(j)/float(jmt)
         B0=0.
         b(i,j,k,:) = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo
      end subroutine initial_conditions




      subroutine restoring_zones(fb)
      use cpflame_module
      implicit none
      real :: fb(imt,jmt,km)
      integer :: i,j,k
      real :: z,T_rest,x,y,B0
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
      integer :: k,i,j
      real :: x,y
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      do j=1,jmt
       do i=1,imt
        y = (yu(j)-yu(2))/ (yu(jmt-1)-yu(2))
        surf_tau(i,j,1) = .2e-3*sin(pi*y)*maskU(i,j,km-1)
       enddo
      enddo
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
      integer :: i,k
      real :: z
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
