#include "options.inc"

c=======================================================================
c     Templates for setup
c
c=======================================================================

      subroutine set_parameter
      use cpflame_module
      implicit none
      real :: fac=0.50
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=200*fac;km=25*fac;jmt=imt
      dx=1000/fac; 
      dz=100/fac; 
      dt_in=100/fac
      eps2D_sor = 1e-5
      eps3D_sor = 1e-4
      runlen=0.25/fac**3
      snap_int = 0.01
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
      enable_hydrostatic         =.true.

      enable_quicker_advection   =.true.
      enable_biharmonic_friction =.true.
      enable_vert_biha_friction  =.true.
      enable_biharmonic_diffusion=.true.
      enable_vert_biha_diffusion =.true.
      Ahbi = (15./fac**2)*dx**2
      Khbi = Ahbi
      Avbi = (0.3/fac**2)*dz**2
      Kvbi = Avbi
      lat_ref= 60.
      beta   = 2*omega*cos(lat_ref/180.*pi)/radius
      N_0 = 2.5e-3
      M_0 = 0.
      end subroutine set_parameter


      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: B0,x,fxa,y  ! temp = b/0.2*tho_0/g
c ----------------------------------
c      add here initial conditions
c ----------------------------------
      do k=1,km  ! Rossby radius is  N h /(f pi)
       do j=1,jmt
        do i=1,imt
         x=float(i)/float(imt)
         B0=1e-9*sin(x*2.5*pi)
         b(i,j,k,:)  = (B0-N_0**2*zt(k))*maskT(i,j,k)
        enddo
       enddo
      enddo

      do j=1,jmt
       do i=1,imt
        x=float(i-imt/2)*dx
        y=float(j-jmt/2)*dx
        fxa = sqrt( x**2+y**2 )
        if (fxa<40e3) b(i,j,km/2:km,:)=0
       enddo
      enddo

      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones


      subroutine boundary_conditions
      use cpflame_module
      implicit none
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
