#include "options.inc"

c=======================================================================
c     Templates for setup
c
c     Test for sdvection schemes,  see also initialization in tracer.F
c=======================================================================


      subroutine set_parameter
      use cpflame_module
      implicit none
c ----------------------------------
c       set here main parameter
c ----------------------------------
      imt=32;km=3;jmt=3

      dx=25
      dz=25 
      dt_in=2.5
      eps2D_sor = 1e-6
      eps3D_sor = 1e-6
      runlen=2*360./86400.0 
      snap_int = 1/86400.0
      enable_cyclic_x            =.true.
      enable_cyclic_y            =.true.
c      enable_4th_advection       =.true.
c      enable_quicker_advection   =.true.
c      enable_upwind_advection   =.true.
      enable_lax_advection   =.true.
c      enable_lim_advection   =.true.
      enable_hydrostatic         =.false.

      A_h = 0
      K_h = 0
      A_v = 0
      K_v = 0

      lat_ref=0.
      beta   =0.
      N_0 = 0.0
      M_0 = 0.0
      end subroutine set_parameter



      subroutine initial_conditions
      use cpflame_module
      implicit none
      integer :: i,j,k
      real :: fxa
      do k=1,km
       do j=1,jmt
        do i=1,imt
         b(i,j,k,:)=0*maskT(i,j,k)
         u(i,j,k,1,:)=1
        enddo
       enddo
      enddo
      end subroutine initial_conditions



      subroutine restoring_zones
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: T_rest,B0
c ----------------------------------
c      add here restoring zones
c ----------------------------------
      end subroutine restoring_zones


      subroutine momentum_restoring_zones
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: T_rest,B0
c ----------------------------------
c      add here restoring zones for momentum
c ----------------------------------
      end subroutine momentum_restoring_zones



      subroutine boundary_conditions
      use cpflame_module
      implicit none
c ----------------------------------
c    add here boundary conditions
c ----------------------------------
      end subroutine boundary_conditions



      subroutine topography
      use cpflame_module
      implicit none
c ----------------------------------
c      Add here topography  
c ----------------------------------
      end subroutine topography
