#include "options.inc"
    



      subroutine integrate_buoyancy
c=======================================================================
c       solve prognostic equation for buoyancy
c=======================================================================
      use cpflame_module
      implicit none
      integer :: i,j,k,js,je
      real :: adv_fe(imt,jmt,km), adv_ft(imt,jmt,km)
      real :: adv_fn(imt,jmt,km), diff_fn(imt,jmt,km)
      real :: diff_fe(imt,jmt,km),diff_ft(imt,jmt,km),fxa

      js=max(2,js_pe); je = min(je_pe,jmt-1)
c---------------------------------------------------------------------------------
c       db/dt = - div( u b) + nabla * K_h nabla b + (K_b b_z)_z
c---------------------------------------------------------------------------------
      adv_fe(:,js_pe:je_pe,:)=0
      adv_fn(:,js_pe:je_pe,:)=0
      adv_ft(:,js_pe:je_pe,:)=0
      call adv_flux(adv_fe,adv_fn,adv_ft,b)
      call border_exchg3D(adv_fn,1)
      call setcyclic3D(adv_fe)
      call setcyclic3D(adv_fn)

      diff_fe(:,js_pe:je_pe,:)=0
      diff_fn(:,js_pe:je_pe,:)=0
      diff_ft(:,js_pe:je_pe,:)=0
c---------------------------------------------------------------------------------
c      horizontal diffusion
c---------------------------------------------------------------------------------
      do k=2,km-1
        do j=js,je
         do i=1,imt-1
          fxa=K_h*maskU(i,j,k)
          diff_fe(i,j,k)=fxa*(b(i+1,j,k,taum1)-b(i,j,k,taum1))/dx
         enddo
        enddo
      enddo
      call setcyclic3D(diff_fe)
      do k=2,km-1
        do j=js,je 
         do i=2,imt-1
          fxa=K_h*maskV(i,j,k)
          diff_fn(i,j,k)=fxa*(b(i,j+1,k,taum1)-b(i,j,k,taum1))/dx
         enddo
        enddo
      enddo
      call border_exchg3D(diff_fn,1)
      call setcyclic3D(diff_fn)
c---------------------------------------------------------------------------------
c      vertical diffusion
c---------------------------------------------------------------------------------
      do k=1,km-2
       do j=js,je
        do i=2,imt-1
         fxa=K_v*maskW(i,j,k)
         diff_ft(i,j,k)=fxa*(b(i,j,k+1,taum1)-b(i,j,k,taum1))/dz
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c      add surface and bottom boundary conditions
c---------------------------------------------------------------------------------
      do j=js,je
       diff_ft(:,j,km-1)=surf_flux(:,j)*maskT(:,j,km-1)
       diff_ft(:,j,1)   =bottom_flux(:,j)*maskT(:,j,2)
      enddo
c---------------------------------------------------------------------------------
c       time tendency of b
c---------------------------------------------------------------------------------
      do k=2,km-1
       do j=js,je
        do i=2,imt-1
         b(i,j,k,taup1)=b(i,j,k,taum1)+maskT(i,j,k)*c2dt*( 
     &  -(adv_fe(i,j,k)-adv_fe(i-1,j,k))/dx
     &  -(adv_fn(i,j,k)-adv_fn(i,j-1,k))/dx
     &  -(adv_ft(i,j,k)-adv_ft(i,j,k-1))/dz
     &  +(diff_ft(i,j,k)-diff_ft(i,j,k-1))/dz
     &  +(diff_fe(i,j,k)-diff_fe(i-1,j,k))/dx
     &  +(diff_fn(i,j,k)-diff_fn(i,j-1,k))/dx  )
        enddo
       enddo
      enddo
c---------------------------------------------------------------------------------
c       Biharmonic diffusion (horizontal and vertical)
c---------------------------------------------------------------------------------
      if (enable_biharmonic_diffusion) 
     &         call biha_mix(diff_fe,diff_fn,diff_ft,b)
c---------------------------------------------------------------------------------
c      Nudging terms
c---------------------------------------------------------------------------------
      call restoring_zones
c---------------------------------------------------------------------------------
c      remove unstable stratification      
c---------------------------------------------------------------------------------
      if (enable_hydrostatic) call convect
c---------------------------------------------------------------------------------
c      Boundary exchange 
c---------------------------------------------------------------------------------
      call border_exchg3D(b(:,:,:,taup1),2)
      call setcyclic3D(b(:,:,:,taup1) )


      end subroutine integrate_buoyancy





