c
c-----------------------------------------------------------------------
c     file contains baroclinic part of BARBI
c      
c-----------------------------------------------------------------------
c
      subroutine adv_vel ()
c=======================================================================
c     Calculate barotropic advection velocities
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      integer :: i,j
      real (kind=8) :: dyr,fxa,fxb
c
c-----------------------------------------------------------------------
c     advection velocity on northern face of "T" cells. Note the
c     imbedded cosine.
c     adv_vnt = WT_AVG_X(u(1,1,1,2,tau))
c-----------------------------------------------------------------------
c
      do j=1,jmt
       do i=2,imt
        adv_vnt(i,j) = (u(i,j,2,tau)*dxu(i)*hu(i,j) +   
     &            u(i-1,j,2,tau)*dxu(i-1)*hu(i-1,j))*csu(j)*dxt2r(i)
       enddo
      enddo
      if (cyclic) then
       adv_vnt(1,:)   = adv_vnt(imt-1,:)
       adv_vnt(imt,:) = adv_vnt(2,:)
      endif
c
c-----------------------------------------------------------------------
c     advection velocity on the eastern face of "T" cells
c     adv_vet = WT_AVG_Y(u(1,1,1,1,tau))
c-----------------------------------------------------------------------
c
      do j=2,jmt
       do i=1,imt
        adv_vet(i,j) = (u(i,j,1,tau)*dyu(j)*hu(i,j) + 
     &           u(i,j-1,1,tau)*dyu(j-1)*hu(i,j-1))*dyt2r(j)
       enddo
      enddo
      end subroutine adv_vel




      subroutine moments (n)
c=======================================================================
c     Integrate the vertical moment F_n = h^{n-1} G_n
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      integer n,i,j
      real (kind=8) :: adv_fe(imt,jmt),adv_fn(imt,jmt),fxb,t1,t2
      real (kind=8) :: adv_te(imt,jmt),adv_tn(imt,jmt)
      real (kind=8) :: ux(imt,jmt),vy(imt,jmt)
      real (kind=8) :: fxa,tarea
c
c-----------------------------------------------------------------------
c     statement functions
c-----------------------------------------------------------------------
c
      real (kind=8) :: adv_gx,adv_gy,adv_gtx,adv_gty
      real (kind=8) :: diff_fe(imt,jmt),diff_fn(imt,jmt),diff_tx,diff_ty
c 
c-----------------------------------------------------------------------
c     Advection of F_n by the barotropic flow  : h^n U grad F_n/h^(n+1)
c-----------------------------------------------------------------------
c
      ADV_Gx(i,j) = h(i,j)**n*
     &              (adv_fe(i,j) - adv_fe(i-1,j))*cstdxt2r(i,j)
      ADV_Gy(i,j) = h(i,j)**n*
     &               (adv_fn(i,j) - adv_fn(i,j-1))*cstdyt2r(j)
c
c-----------------------------------------------------------------------
c     Diffusion
c-----------------------------------------------------------------------
c
      DIFF_Tx(i,j) = (diff_fe(i,j)*tmask(i+1,j)
     &                - diff_fe(i-1,j)*tmask(i-1,j))*cstdxtr(i,j)
      DIFF_Ty(i,j) =  cstdytr(j)*
     &      (diff_fn(i,j)*tmask(i,j+1)-diff_fn(i,j-1)*tmask(i,j-1))

      integer :: np2
      real (kind=8)  :: fac(imt,jmt)
c
      real (kind=8) :: var,var1,ADV_ty,phase_vel,ADV_tx
      real (kind=8) :: s_querm(imt,jmt)

      real (kind=8) :: u1,u2,u3,u4, v1,v2,v3,v4

c-----------------------------------------------------------------------
c
c     Production of F_n due lifting of mean density
c     by barotropic  vertical velocities
c     N_o^2 /(n+2) h^n U grad h =  N_o^2/(n+2)/(n+1) div ( U h^{n+1} )
c                               =  N_o^2/(n+2)/(n+1) div ( u h^{n+2} )
c
c     Production of moment F_n due to the lifting
c     of the background mass field by the baroclinic flow:
c     N_0^2 /(n+1)  div ub_(n+1)
c
c     Combined effect is calculated here
c
c-----------------------------------------------------------------------

      s_querm=0.; ux=0.; vy=0.
      do j=2,jmt-1
        do i=2,imt-1

         u1=-ub(i  ,j  ,1,tau,n)
     &      -u(i  ,j  ,1,tau)*hu(i  ,j  )**(n+2)/(n+2)
         u2=-ub(i  ,j-1,1,tau,n)
     &      -u(i  ,j-1,1,tau)*hu(i  ,j-1)**(n+2)/(n+2)
         u3=-ub(i-1,j  ,1,tau,n)
     &      -u(i-1,j  ,1,tau)*hu(i-1,j  )**(n+2)/(n+2)
         u4=-ub(i-1,j-1,1,tau,n)
     &      -u(i-1,j-1,1,tau)*hu(i-1,j-1)**(n+2)/(n+2)

         ux(i,j)=(
     &     (u1*dyu(j) +  u2*dyu(j-1))*dyt2r(j)
     &    -(u3*dyu(j)+   u4*dyu(j-1))*dyt2r(j)
     &       )*cstr(j)*dxtr(i) /(n+1)

         v1=-ub(i  ,j  ,2,tau,n)
     &      -u(i  ,j  ,2,tau)*hu(i  ,j  )**(n+2)/(n+2)
         v2=-ub(i-1,j  ,2,tau,n)
     &      -u(i-1,j  ,2,tau)*hu(i-1,j  )**(n+2)/(n+2)
         v3=-ub(i  ,j-1,2,tau,n)
     &      -u(i  ,j-1,2,tau)*hu(i  ,j-1)**(n+2)/(n+2)
         v4=-ub(i-1,j-1,2,tau,n)
     &      -u(i-1,j-1,2,tau)*hu(i-1,j-1)**(n+2)/(n+2)

         vy(i,j)= (
     &       (v1*dxu(i)+ v2*dxu(i-1))*csu(j  )*dxt2r(i)
     &      -(v3*dxu(i)+ v4*dxu(i-1))*csu(j-1)*dxt2r(i)
     &       )*cstr(j)*dytr(j) /(n+1)

         s_querm(i,j)= N0sqr*(ux(i,j)+vy(i,j))
       enddo
      enddo

      if (cyclic) then
       s_querm(1,:)   = s_querm(imt-1,:)
       s_querm(imt,:) = s_querm(2,:)
      endif
c
c-----------------------------------------------------------------------
c     calculate 2*advective flux across eastern face of "T" cells.
c-----------------------------------------------------------------------
c
      do j=2,jmt-1
         do i=1,imt-1
	  adv_fe(i,j) = adv_vet(i,j)*
     &        (G(i,j,n,tau)*hr(i,j)**(n+1) 
     &        +G(i+1,j,n,tau)*hr(i+1,j)**(n+1))
         enddo
      enddo

      do j=1,jmt-1
       do i=2,imt-1
	adv_fn(i,j) = adv_vnt(i,j)*
     &      (G(i,j,n,tau)*hr(i,j)**(n+1)
     &      +G(i,j+1,n,tau)*hr(i,j+1)**(n+1))
       enddo
      enddo
c
c-----------------------------------------------------------------------
c       calculate diffusive flux across eastern and northern faces 
c       of "T" cells due to parameterizations for diffusion.
c-----------------------------------------------------------------------
c
      do j=2,jmt-1
       do i=1,imt-1
        diff_fe(i,j) = ah_cstdxur(i,j)*
     &             (G(i+1,j,n,taum1) - G(i,j,n,taum1))
       enddo
      enddo

      do j=1,jmt-1
       fxa= ah*csu(j)*dyur(j) 
       do i=2,imt-1
        diff_fn(i,j) = fxa * (G(i,j+1,n,taum1)
     &                      - G(i,j,n,taum1))
       enddo
      enddo
c
c-----------------------------------------------------------------------
c      solve for n-th moment
c-----------------------------------------------------------------------
c
      do j=2,jmt-1
       do i=2,imt-1
	G(i,j,n,taup1) = G(i,j,n,taum1) + c2dt*(
     &        (DIFF_Tx(i,j) + DIFF_Ty(i,j)) 
     &      - (ADV_Gx(i,j)  + ADV_Gy(i,j) )
     &      - s_querm(i,j) )*tmask(i,j)
       enddo
      enddo
c
c     cyclic boundary conditions
c
      if (cyclic) then
       g(1,:,n,taup1)   = g(imt-1,:,n,taup1)
       g(imt,:,n,taup1) = g(2,:,n,taup1)
      endif
c
c     open boundary conditions
c
      if (enable_obc_south) then
c      radiation condition at the southern wall
       j=2
       var = -dyu(j+1)/dt
       do i=2,imt-1
        var1=g(i,j+2,n,taum1)-g(i,j+1,n,taum1)
        if (var1==0.) then
	 phase_vel=var
        else
	 phase_vel=var*(g(i,j+1,n,tau)-g(i,j+1,n,taum1))
     &                  /var1*tmask(i,j)
         if (phase_vel.gt. 0.) phase_vel=0.
	 if (phase_vel.lt.var) phase_vel=var
        endif
        ADV_Ty=-phase_vel*(g(i,j+1,n,tau)-g(i,j,n,tau))/dyu(j)
        G(i,j,n,taup1) = G(i,j,n,tau) + dt*(
     &         DIFF_Tx(i,j) + DIFF_Ty(i,j) + ADV_Ty 
     &             )*tmask(i,j)
        G(i,j-1,n,taup1)=G(i,j,n,taup1)
       enddo
      endif

      if (enable_obc_north) then
c     radiation condition at the northern wall
       j=jmt-1
       var=dyu(j-1)/dt
       do i=2,imt-1
        var1=g(i,j-1,n,taum1)-g(i,j-2,n,taum1)
        if (var1.eq.0.) then
 	 phase_vel=var
        else
       	 phase_vel=-var*(g(i,j-1,n,tau)-g(i,j-1,n,taum1))
     &                   /var1*tmask(i,j)
         if (phase_vel.lt.  0) phase_vel=0.
	 if (phase_vel.gt.var) phase_vel=var
        endif
        ADV_Ty=-(phase_vel)*(g(i,j,n,tau)-g(i,j-1,n,tau))/dyu(j-1)
        G(i,j,n,taup1) = G(i,j,n,tau) + dt*(
     &               DIFF_Tx(i,j) + DIFF_Ty(i,j) + ADV_Ty 
     &             )*tmask(i,j)
        G( i,j+1,n,taup1)  =G(i,j,n,taup1)
       enddo
      endif

      if (enable_obc_west) then
c      western wall:
       i=2
       do j=2,jmt-1
        var = -dxu(i+1)*csu(j)/dt 
	var1=g(i+2,j,n,taum1)-g(i+1,j,n,taum1)
	if (var1.eq.0.) then
	 phase_vel=var
        else
	 phase_vel=var*(g(i+1,j,n,tau)-g(i+1,j,n,taum1))
     &                            /var1*tmask(i,j)
         if (phase_vel.gt. 0.) phase_vel=0.
	 if (phase_vel.lt.var) phase_vel=var
	endif
        ADV_Tx=-phase_vel*(g(i+1,j,n,tau)-g(i,j,n,tau))*dxur(i)*csur(j)
        G(i,j,n,taup1) = G(i,j,n,tau) + dt*(
     &               DIFF_Tx(i,j) + DIFF_Ty(i,j)+ ADV_Tx 
     &             )*tmask(i,j)
        G(i-1,j,n,taup1)=G(i,j,n,taup1)
       enddo
      endif

      if (enable_obc_west) then
c      eastern wall:
       i= imt-1  
       do j=2,jmt-1
        var = dxu(i-2)*csu(j)/dt
	var1= g(i-1,j,n,taum1)-g(i-2,j,n,taum1)
	if (var1.eq.0.) then
	 phase_vel=var
	else
	 phase_vel=-var*(g(i-1,j,n,tau)-g(i-1,j,n,taum1))/var1*tmask(i,j)
         if (phase_vel.lt. 0.) phase_vel=0.
	 if (phase_vel.gt.var) phase_vel=var
	endif
        ADV_Tx=-phase_vel*(g(i,j,n,tau)-g(i-1,j,n,tau))
     &                          *dxur(i-1)*csur(j)
        G(i,j,n,taup1) = G(i,j,n,tau) + dt*(
     &               DIFF_Tx(i,j) + DIFF_Ty(i,j)+ ADV_Tx 
     &             )*tmask(i,j)
        G( i+1,j,n,taup1)  = G(i,j,n,taup1)
       enddo
      endif

      end subroutine moments




      subroutine clinic(no)
c=======================================================================
c     Integrate the baroclinic velocity moment no
c     ub_{n+1} = int_{-h}^0 z^{n+1} u_baroclin dz
c     Note that indicees with respect to the order in hierachy 
c     in ub(,,,)  are shifted by one so that ub_{n+1) is 
c     referenced here as ub(,,,n)
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      real (kind=8) :: diff_fe(imt,jmt)
      real (kind=8) :: Bforc(imt,jmt,2)
      real (kind=8) :: forc2(imt,jmt,2)
      real (kind=8) :: fxa,fxb,ux,vy,t1,t2,ex,ey,ex1,ey1,fac(imt,jmt)
      real (kind=8) :: var,var1,ADV_ty,phase_vel,ADV_tx
      integer       :: i,j,no,n,nn,nop2
c
c-----------------------------------------------------------------------
c     statement functions
c-----------------------------------------------------------------------
c
      real (kind=8) :: diff_ux,diff_uy,diff_metric
      DIFF_Ux(i,j) = (diff_fe(i,j)-diff_fe(i-1,j))*csudxur(i,j)
      DIFF_Uy(i,j) = 
     &  amc_north(j)*(ub(i,j+1,n,taum1,no) - ub(i,j,n,taum1,no) )
     & -amc_south(j)*(ub(i,j,n,taum1,no)   - ub(i,j-1,n,taum1,no) )
      DIFF_metric(i,j,n)=am3(j)*ub(i,j,n,taum1,no)+am4(j,n)*dxmetr(i)*
     &         (ub(i+1,j,3-n,taum1,no) - ub(i-1,j,3-n,taum1,no))
c
c-----------------------------------------------------------------------
c    calculate the baroclinic pressure gradient B_(n+1)
c-----------------------------------------------------------------------
c
c      use here the truncation for F_(n+2):  
c      F_(n+2) = gamma h^2 F_n 
c
      Bforc(:,:,:)=0.
      if (n_order.ge.no+2) then
       do j=2,jmt-1
        fxa  = csur(j)
        fxb  = dyu2r(j)
        do i=2,imt-1
         t1  =  G(i+1,j+1,no+2,tau)  - G(i  ,j  ,no+2,tau)
         t2  =  G(i  ,j+1,no+2,tau)  - G(i+1,j  ,no+2,tau)
         ex = (t1-t2)*fxa*dxu2r(i)
         ey = (t1+t2)*fxb
         t1  =   G(i+1,j+1,1,tau)- G(i , j,1,tau)
         t2  =   G(i  ,j+1,1,tau)- G(i+1,j,1,tau)
         ex1 = (t1-t2)*fxa*dxu2r(i)
         ey1 = (t1+t2)*fxb
c        ex = gamma  d/dx ( h^2 F_n )   or    ex = d/dx F_{n+2}
c        ex1 = d/dx F_1
c        B_{n+1} = 1/(n+2) ( -1^n h^{n+1} d/dx F_1 + ex )
         Bforc(i,j,1)=1./(no+2.)* ((-1)**no*hu(i,j)**(no+1)*ex1 +ex)
         Bforc(i,j,2)=1./(no+2.)* ((-1)**no*hu(i,j)**(no+1)*ey1 +ey)
        enddo
       enddo
      else

       do j=2,jmt-1
        fxa  = csur(j)
        fxb  = dyu2r(j)
        do i=2,imt-1
         t1=0.;t2=0.
         do n=1,n_order,2
          t1 = t1+ gamma(i+1,j+1,n)*G(i+1,j+1,n,tau)
     &                *h(i+1,j+1)**(no+2-n)
     &           - gamma(i  ,j  ,n)*G(i  ,j  ,n,tau)
     &                *h(i  ,j  )**(no+2-n)
          t2 = t2+ gamma(i  ,j+1,n)*G(i  ,j+1,n,tau)
     &                *h(i  ,j+1)**(no+2-n)
     &           - gamma(i+1,j  ,n)*G(i+1,j  ,n,tau)
     &                *h(i+1,j  )**(no+2-n)
         enddo
         ex = (t1-t2)*fxa*dxu2r(i)
         ey = (t1+t2)*fxb
         t1  =   G(i+1,j+1,1,tau)- G(i , j,1,tau)
         t2  =   G(i  ,j+1,1,tau)- G(i+1,j,1,tau)
         ex1 = (t1-t2)*fxa*dxu2r(i)
         ey1 = (t1+t2)*fxb
         Bforc(i,j,1)=1./(no+2.)* ((-1)**no*hu(i,j)**(no+1)*ex1 +ex)
         Bforc(i,j,2)=1./(no+2.)* ((-1)**no*hu(i,j)**(no+1)*ey1 +ey)
        enddo
       enddo
      endif

      if (cyclic) then
       Bforc(1,:,:)   = Bforc(imt-1,:,:)
       Bforc(imt,:,:) = Bforc(2,:,:)
      endif
c
c-----------------------------------------------------------------------
c     calculate the coupling to lower orders of ub (ub_0=0)
c-----------------------------------------------------------------------
c
      forc2=0.
      if (no-2.ge.0) then
       forc2(:,:,1)=Av*no*(no+1.)*ub(:,:,1,tau,no-2) ! ub(,,,n+1) = ub(,,,no)
       forc2(:,:,2)=Av*no*(no+1.)*ub(:,:,2,tau,no-2)
       if (cyclic) then
        forc2(1,:,:)   = forc2(imt-1,:,:)
        forc2(imt,:,:) = forc2(2,:,:)
       endif
      endif
c
c-----------------------------------------------------------------------
c     loop over the two velocity components and solve for them
c-----------------------------------------------------------------------
c
      do n=1,2
        do j=2,jmt-1
         do i=1,imt-1
          diff_fe(i,j)= 
     &     am_csudxtr(i,j)*(ub(i+1,j,n,taum1,no)
     &                     -ub(i,j,n,taum1,no) )
         enddo
        enddo
        do j=2,jmt-1
         do i=2,imt-1
	  ub(i,j,n,taup1,no) = (
     &     + DIFF_Ux(i,j)+DIFF_Uy(i,j) + DIFF_metric(i,j,n)
     &     + cori(i,j,n)*ub(i,j,3-n,tau,no) 
     &     - Bforc(i,j,n) 
     &     + forc2(i,j,n) 
     &     +(-1)**no*wind(i,j,n)*hu(i,j)**(no+1)/(no+2.)
     &      )*umask(i,j)
         enddo
        enddo
      enddo ! n

      do j=2,jmt-1
       do i=2,imt-1
	ub(i,j,1,taup1,no) = ub(i,j,1,taum1,no) + c2dt*
     &                       ub(i,j,1,taup1,no)
	ub(i,j,2,taup1,no) = ub(i,j,2,taum1,no) + c2dt*
     &                       ub(i,j,2,taup1,no)
       enddo
      enddo

      do n=1,2
c
c      cyclic boundary conditions
c
        if (cyclic) then
         ub(1,:,n,taup1,no)   = ub(imt-1,:,n,taup1,no)
         ub(imt,:,n,taup1,no) = ub(2,:,n,taup1,no)
        endif
c
c      open boundary conditions
c
        if (enable_obc_south) then
         j=2
         do i=2,imt-1
          ub(i,j-1,n,taup1,no)=ub(i,j,n,taup1,no)
         enddo
        endif

        if (enable_obc_north) then
         j=jmt-2
         do i=2,imt-1
          ub(i,j+1,n,taup1,no)=ub(i,j,n,taup1,no)
          ub(i,j+2,n,taup1,no)=ub(i,j,n,taup1,no)
         enddo
        endif

        if (enable_obc_west) then
         i=2
         do j=2,jmt-1
          ub(i-1,j,n,taup1,no)=ub(i,j,n,taup1,no)
         enddo
        endif

        if (enable_obc_west) then
         i= imt-1  
         do j=2,jmt-1
          ub(i+1,j,n,taup1,no)=ub(i-1,j,n,taup1,no)
          ub(i  ,j,n,taup1,no)=ub(i-1,j,n,taup1,no)
         enddo
        endif

      enddo ! n
      end subroutine clinic





