c
c-----------------------------------------------------------------------
c     file contains variable configuration dependencies
c
c-----------------------------------------------------------------------
c

      subroutine simple_grid()
c=======================================================================
c     set up a simple B grid
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      integer j,i
      real (kind=8) x0,y0,dx,dy
c
c     mid latitude basin
c
      x0=280.
      y0=30.0
      dx   = 50. / imt
      dy = dx*cos(y0/180.*pi)
c
c     equatorial basin
c
c      dx  = 2.0
c      dy  = 2.0
c      y0=-jmt/2.*dy+dy/2.
c      x0=280.

      print*,' hor. resolution : ',dx,' x ',dy, ' (deg)'

      dxtdeg =  dx; dytdeg =  dy; dxudeg =  dx; dyudeg =  dy  
      xt(1)=x0; xu(1)=x0+dxtdeg(1)/2.

      do i=2,imt
        xt(i)=xt(i-1)+dxtdeg(i)
        xu(i)=xu(i-1)+dxudeg(i)
      enddo
      yt(1)=y0; yu(1)=y0+dytdeg(1)/2.
      do i=2,jmt
        yt(i)=yt(i-1)+dytdeg(i)
        yu(i)=yu(i-1)+dyudeg(i)
      enddo
      end subroutine simple_grid


      subroutine simple_topog()
c=======================================================================
c     Define a simple topography 
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      integer i,j,len
      real (kind=8) hx,eps,scal
c
c      flat bottom
c
       do j=1,jmt
        do i=1,imt
         h(i,j)=h_0 
        enddo
       enddo
c
c       some ridges
c
       do j=1,jmt
        do i=1,imt
c         hx = ((i-1.)/(imt-1.)-0.5)*2
c         h(i,j) = h_0*( 1-0.2*exp( - (hx)**2 *3. ) )
c         h(i,j)=h_0 - 2000.* exp( - (xt(i)-xt(imt/2+1))**2/3.**2 )
         h(i,j)=h_0 - 2500.* exp( - (xt(i)-xt(imt/2+1))**2/15.**2 )
c         h(i,j)=h_0 - 4500.* exp( - (xt(i)-xt(imt/2+1))**2/15.**2 )
        enddo
       enddo

c        h(2,:) =  500.     
c        h(3,:) =  500.     
c        h(4,:) =  2001.82902
c        h(5,:) =  3000.00
c        h(6,:) =  4000.00
c        h(7,:) =  5000.00

      end subroutine simple_topog



      subroutine simple_wind
c=======================================================================
c     Define a simple wind stress
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      integer :: i,j
      wind=0.
c
c     cosine shaped zonal wind stress
c
      do i=1,imt
       do j=1,jmt
         wind(i,j,1)= -0.06*cos((j-1.)/(jmt-1.)*pi*2.)/rho0
       enddo
      enddo
c
c     zonal wind stress in western basin
c
c      wind(1:nint(imt/6.),:,1)=-0.05/rho0
      end subroutine simple_wind



      subroutine init_cond(itt_in)
c=======================================================================
c     Define simple initial conditions
c
c                      C.Eden Feb. 2002 (mailto ceden@phys.ocean.dal.ca)
c=======================================================================
      use barbi_module
      implicit none
      integer it,n,i,j,itt_in
      real (kind=8) :: N_real = 0.0026
      g=-0.0; u=-0.0; ub=0.0
      zu=0.; grad_E=0.; psi=0.; dpsi=0.
      itt_in=0
      do it=0,2
       do n=1,2
         where( umask == 1.) u(:,:,n,it)=0.
       enddo
      enddo
c
c     a gaussian pertubation
c
c      do i=2,imt-1
c       do j=2,jmt-1
c         g(i,j,1,:)=500.*exp( - (yt(j)-yt(jmt/2))**2/10.**2
c     &                  -  (xt(i)-xt(3*imt/4))**2/10.**2 )*tmask(i,j)
c       enddo
c      enddo

      if (cyclic) then
        g(1,:,:,:)   = g(imt-1,:,:,:)
        g(imt,:,:,:) = g(2,:,:,:)
      endif
      end subroutine init_cond
